access_by_lua_block {
    local res, err = require("resty.openidc").authenticate(
        {
            redirect_uri = "http://localhost/auth/callback",
            discovery = "https://accounts.google.com/.well-known/openid-configuration",
            logout_path = "/auth/logout",
            redirect_after_logout_uri = "/auth/logged-out",
            revoke_tokens_on_logout = true,
            client_id = "YOUR_CLIENT_ID",
            client_secret = "YOUR_CLIENT_SECRET"
        }
    )

    if err then
        ngx.status = 500
        ngx.say(err)
        ngx.exit(ngx.HTTP_INTERNAL_SERVER_ERROR)
    end

    if not string.match(res.user.email, "gmail.com$") then
        ngx.exit(ngx.HTTP_FORBIDDEN)
    end
}
